'Programm ......... : Programmierbares Temperaturmodul PTM
'                     (Anzeige auf einem 6-stelligen LED-Display mit 7-Segment-
'                      anzeige-Elemente)
'
'Programminhalt ... : - Auswertung von einem Temperaturgeber ber eine geschirm-
'                       te Zweidrahtleitung
'                     - Kurzschlu- und Leitungsbruchberwachung
'                     - Anpassung der Leuchtintensitt an die Umgebungshellig-
'                       keit
'                     - Ausgang fr ein Relais mit der Einstellmglichkeit ver-
'                       schiedener Schalttemperaturen fr das Ein- bzw. Aus-
'                       schalten
'
'Hinweise:
' - Eine Erweiterung auf zwei Sensoren ist bei diesem MC-Typ durch die Gre des
'   Programmspeichers nur bedingt mglich.
' - Fr den Sensoranschlu sollte eine abgeschirmte Leitung verwendet werden.
'
'                     -XX.XC
'                           |--- 6. Stelle (Anzeige: C)
'                          |---- 5. Stelle (Anzeige: )
'                         |----- 4. Stelle (Temperatur-Digit:    .1 mit Punkt)
'                       |------- 3. Stelle (Temperatur-Digit:   1. )
'                      |-------- 2. Stelle (Temperatur-Digit:  10. )
'                     |--------- 1. Stelle (Temperatur-Digit: 100. ) bzw.
'                                   Vorzeichen bei Temperaturen < 0C
'
'Programmierer .... : Ingolf Bauer (ingolf.bauer@nexgo.de)
'Version .......... : 1.0
'Datum ............ : 01.01.2007
'
'-------------------------------------------------------------------------------
'
'Historie
'========
'V 1.0 (01.01.2007 - nderungen zur Version 0.9):
'
'00. Programmspeicher
' - - - - - - - - - -
'    Programmspeicher des MCs (Programm-Flashspeicher): 98%
'
'01. Programm
' - - - - - -
'    Die Dynamik der Anzeige wurde reduziert. Der Wert ndert sich jetzt nur
'    in Schritten von +/- 0,1 C.
'    Bedingt durch den knappen Programmspeicherplatz wird nur noch ein Tempera-
'    tursensor verwendet.
'    Der bis zu Version 0.9 vorhandene Befehlscode fr den Temperatursensor 2
'    wurde auskommentiert.
'    Ein zweiter Sensor ist anschliebar, die Funktionsfhigkeit des PTM mu
'    dann aber eingeschrnkt werden.
'
'02. Funktionserweiterung: Relais
' - - - - - - - - - - - - - - - -
'    ber die Bedientasten ist es mglich, zwei Temperaturen fr das Zu- bzw.
'    Abschalten eines Relais zu programmieren.
'    Zu beachten ist, da bei einer neuen Programmierung mit TwinAvr diese Werte
'    neu eingetragen werden mssen, da der EEprombereich vor der Programmierung
'    gelscht wird.
'
'-------------------------------------------------------------------------------
'
'Allgemeine Informationen
'========================
'
'01. Einstellungen
' - - - - - - - -
'    Im Men (Compiler-Chip) vor dem Compilieren mindestens einstellen mit:
'    > HW Stack 64   Soft Stack 32   Framesize 16
'
'    Es kommt sonst zu undefinierten Sprngen, falschen Anzeigen u. . Dingen,
'    woran man beim Testen des Programms schnell verzweifeln kann.
'    Auerdem mu auf die genaue Angabe des Chips (M8) geachtet werden.
'    Andere MC der AVR-Serie knnen ggf. auch eingesetzt werden.
'    (z. B. der pinkompatible AT90S4433, der ATmega16, ...)
'
'02. Mglichkeiten der Linearisierung der Kennlinie des Temperatursensors
' - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
'    Die eine Mglichkeit besteht darin, fr jeden anzuzeigenden Temperaturwert
'    einen Widerstandswert im Programm zu hinterlegen, was fr eine Abstufung
'    mit 1/10-Grad zu sehr groen Datenmengen fhrt (-20...+150 * 10 = 1700).
'
'    Die andere Mglichkeit ist, ber eine Funktion f(x) diesen Wert berechnen
'    zu lassen. Um diese Funktion bestimmen zu knnen, wurden aus der Herstel-
'    lerkennlinie des Sensors Temperatur- und dazugehrigem Widerstandswerte
'    in eine Wertetabelle bernommen und mit Hilfe einer Ausgleichskurve
'    (Pogramm Appomatox) folgende Funktion ermittelt:
'
'        t(R) = -174,047 + 0,293*R - 2297/19796219*R^2 + 1/44811582*R^3 + X
'
'    Konstante  K0_____|   K1__|     K2__________|       K3_______|
'
'    Werte von Sensoren mit abweichender Kennlinie knnen auf die gleiche Art
'    und Weise programmtechnisch verarbeitet werden.
'
'    X: Korrekturfaktor, der per Bedientaste verndert werden kann und dann im
'       EEprom abgelegt wird
'
'03. Formelbersicht
' - - - - - - - - -
'    - Entlade- bzw. Ladezeit eines Kondensators
'      t = -R * C * ln(1-Uc/Ub)
'
'      t: Zeit
'      R: Wert des Widerstandes
'      C: Wert des Kondensators
'     Uc: Spannung am Kondensator
'     Ub: Betriebsspannung
'
'04. Fehlermeldungen
' - - - - - - - - -
'    Err 11: Temperatursensor 1 - Kurzschlu
'    Err 12: Temperatursensor 1 - Leitungsunterbrechung
'
'05. Optionen, die ber das Men aufgerufen werden knnen
' - - - - - - - - - - - - - - - - - - - - - - - - - - - -
'    rE mit Strich oben : Einstellung der Relais-Einschalttemperatur (positiv)
'    rE mit Strich unten: Einstellung der Relais-Einschalttemperatur (negativ)
'
'    rA mit Strich oben : Einstellung der Relais-Ausschalttemperatur (positiv)
'    rA mit Strich unten: Einstellung der Relais-Ausschalttemperatur (negativ)
'
'    S1 mit Strich oben : Korrektur der Temperaturanzeige fr Sensor 1 (positiv)
'    S1 mit Strich unten: Korrektur der Temperaturanzeige fr Sensor 1 (negativ)
'
'    PA ............... : Prfung Anzeige (alle Segmente werden aktiviert)
'
'    End .............. : Men wird nach einigen Sekunden automatisch oder per
'                         Taste 2 sofort verlassen
'
'06. Markierungen
' - - - - - - - -
'    * - vor einer Befehlszeile
'    Diese Eintrge sind erforderlich beim Einsatz von zwei Temperatur-Sensoren.
'    Nicht alle erforderlichen Eintrge sind vorhanden, da sie von Fall zu Fall
'    angepat werden mssen.
'
'-------------------------------------------------------------------------------
'
'I/O-Ports
'=========
' AE/ AA: analoger  Ein-/ Ausgang
' DE/ DA: digitaler Ein-/ Ausgang
' PRG - Programmierung (Signale MOSI, MISO, SCK, Reset)
' STA - Steuerung Anzeige
' STE - Steuerung Eingabe
' STT - Steuerung Temperaturermittlung
'
'==Port B  Funktion      | Signal        | Erluterung                    | Pin
' - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
' - .0: DA STT ......... | REL ......... | Relais ....................... | 14
' - .1: DA STA ......... | DIG_A ....... | A fr 1 aus 8 Dekoder ........ | 15
' - .2: DA STA ......... | DIG_B ....... | B fr 1 aus 8 Dekoder ........ | 16
' - .3: DA STA / PRG ... | DIG_C/ MOSI . | C fr 1 aus 8 Dekoder ........ | 17
' - .4: DA STA / PRG ... | ENAB / MISO . | Enable fr 1 aus 8 Dekoder ... | 18
' - .5: ------ / PRG ... | LAD  / SCK .. | Ladung Kondensator ........... | 19
'
'==Port C  Funktion      | Signal        | Erluterung                    | Pin
' - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
' - .0: AE STA ......... | HEL_T2....... | Anzeigehelligkeit, Taster 2 .. | 23
' - .1: DA STA ......... | SK_a ........ | Segment a (Katode) ........... | 24
' - .2: DA STA ......... | SK_b ........ | Segment b (Katode) ........... | 25
' - .3: DA STA ......... | SK_c ........ | Segment c (Katode) ........... | 26
' - .4: DA STA ......... | SK_d ........ | Segment d (Katode) ........... | 27
' - .5: DA STA ......... | SK_e ........ | Segment e (Katode) ........... | 28
' - .6: ------ / PRG ... | RESET ....... | Reset (optionale Einstellung)  | 01
'
'==Port D  Funktion      | Signal        | Erluterung                    | Pin
' - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
' - .0: DA STT ......... | TS1 ......... | Temperatursensor 1 ........... | 02
' - .1: DA STT ......... | TS2 ......... | Temperatursensor 2 (optional). | 03
' - .2: DE STT ......... | KOM ......... | Komparator-Auswertung ........ | 04
' - .3: DA STT ......... | TSV ......... | R-Vergleichswert ............. | 05
' - .4: DE STE ......... | T1 .......... | Taster 1 ..................... | 06
' - .5: DA STA ......... | SK_f ........ | Segment e (Katode) ........... | 07
' - .6: DA STA ......... | SK_g ........ | Segment f (Katode) ........... | 08
' - .7: DA STA ......... | SK_dp ....... | Segment dp (Katode) .......... | 09
'
'-------------------------------------------------------------------------------
'
'Einstellung der FUSE-Bits mit TwinAvr:
'======================================
' - Frequnzeinstellung (extern, Quarz)
'   CKSEL1- CKSEL3 ... : Haken setzen (111) bei Quarzfrequnz 4 MHz
'   CKSEL0 ........... : Haken ist gesetzt (Lieferzustand)
'
' - Funktion Pin 1 ... : Reset
'   RSTDISBL ......... : Haken ist gesetzt (Lieferzustand)
'
'   ACHTUNG!
'   Wird diese Option verndert, ist mit TwinAvr kein Programmieren mehr
'   mglich, da dafr die RESET-Funktion unbedingt erforderlich ist.
'
'
'                  Anschluschema fr den AVR ATmega8
'                  ==================================
'
'                      ------------|_|------------
'         PRG-Reset -> | 1 [/Reset]      [PC5] 28| -> STA-SK_e
'           STT-TS1 <> | 2 [PD0]         [PC4] 27| -> STA-SK_d
'           STT-TS2 <> | 3 [PD1]         [PC3] 26| -> STA-SK_c
'           STT-KOM -> | 4 [PD2, INT0]   [PC2] 25| -> STA-SK_b
'           STT-TSV <> | 5 [PD3]         [PC1] 24| -> STA-SK_a
'            STE-T1 -> | 6 [PD4]         [PC0] 23| <- STA-HEL / <- STE-T2
'               P5V == | 7 [VCC]        [AGND] 22| == GND (analog)
'               GND == | 8 [GND]        [AREF] 21| ++ Kondensator
'             Quarz ++ | 9 [XT1]        [AVCC] 20| == P5V (analog)
'             Quarz ++ |10 [XT2]     [SCK,PB5] 19| <> STT-LAD   / <- PRG-SCK
'          STA-SK_f <- |11 [PD5]    [MISO,PB4] 18| -> STA-ENAB  / >- PRG-MISO
'          STA-SK_g <- |12 [PD6]    [MOSI,PB3] 17| -> STA-DIG_C / <- PRG-MOSI
'         STA-SK_dp <- |13 [PD7]         [PB2] 16| -> STA-DIG_B
'               REL <- |14 [PB0]         [PB1] 15| -> STA-DIG_A
'                      ---------------------------
'
' P5V/ (analog) ..... : Versorgungsspannung +5 V, stabilisiert
' GND/ (analog) ..... : Masse der Versorgungsspannung
'
'-------------------------------------------------------------------------------
'Steckverbinder
'==============
'X1 - Stromversorgung
'     -----------------
'    | 01  |  02  | 03 |
'     -----------------
'     P5V    P8V   Masse
'      |      |     |--- Stromversorgung fr das PTM-Modul (Masse)
'      |      |--------- Stromversorgung fr das PTM-Modul (Ub >= +8V)
'      |---------------- Stromversorgung fr das PTM-Modul (Ub  = +5V)
'
' - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
'X2 - Temperatursensoren
'     -------------------------
'    | 01  |  02  |  03  |  04 |
'     -------------------------
'      |      |      |      |--- Masse
'      |      |      |---------- Sensoranschlsse (+)
'      |      |----------------- Sensor 1 (-)
'      |------------------------ Sensor 2 (-); optional
'
' - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
'X3 - Tasteneingabe 1 (Einstellung)
'     -----------
'    | 01  |  02 |
'     -----------
'      |      |--- Taster 1
'      |---------- Taster 1 (Masse)
'
' - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
'X4 - Tasteneingabe 2 (Modus)
'     -----------
'    | 01  |  02 |
'     -----------
'      |      |--- Taster 2
'      |---------- Taster 2 (Masse)
'
' - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
'X5 - Fotodiode (Helligkeitssteuerung der Anzeige)
'     -----------
'    | 01  |  02 |
'     -----------
'             |--- Katode
'      |---------- Anode (+5V)
'
' - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
'X6 - Anschlu Programmiermodul (PRM)
'                    PB5    PB3    PB4    /R
'  Pin (AVR)         19     17     18     01
'     -----------------------------------------------------
'    | 01  |  02  |  03  |  04  |  05  |  06  |  07  |  08 |
'     -----------------------------------------------------
'      nc     nc     SCK   MOSI   MISO    /R    PRM+   PRM-
'                    |      |      |                    |---- SV PRM (+5V)
'                    |      |      |             |----------- SV PRM (Masse)
'                    |      |      |      |------------------ /Reset
'                    |------|------|------|------------------ Programmieran-
'                                                             schlsse
' - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
'X7 - Relais
'     -----------
'    | 01  |  02 |
'     -----------
'             |--- Relais (Masse)
'      |---------- Relais (+5V)
'
'-------------------------------------------------------------------------------
'
'Kodierung
'=========
'Anz | Wert | mit Punkt || Anz | Wert | mit Punkt || Anz | Wert | mit Punkt
'                 (+ 128)                  (+ 128)                  (+ 128)
' - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
' 1       6      134        A     119    247          o      92    230
' 2      91      219        b     124    252          n      84    212
' 3      79      207        C      57    185          S     109    237
' 4     102      230        d      94    222         (x)      1    129   **)
' 5     109      237        E     121    249         (y)      8    136   ***)
' 6     125      253        F     113    241          P     115    243
' 7       7      135        H     118    246         *)
' 8     127      255        -      64    192
' 9     111      239             255
' 0      63      191        r      80    208
'
'
'-Wertezuweisung fr die einzelnen Segmente einer 7-Segmentanzeige
'
'      1         Segment a:  1
'      -         Segment b:  2
' 32  | |  2     Segment c:  4
' 64   -         Segment d:  8
' 16  | |  4     Segment e: 16
'      -         Segment f: 32
'      8         Segment g: 64
'
'   *): ab hier bei Bedarf die Felder neu deklarieren (bei mehr als 25 Zeichen)
'  **): Sonderzeichen fr "nach oben"
' ***): Sonderzeichen fr "nach unten"
'
'-------------------------------------------------------------------------------
'
'Definition
   $regfile = "m8def.dat"                        'Prozessor ....... : ATmega8
   $crystal = 4000000                            'Quarzfrequenz ... : 4,0 MHz
'
'-------------------------------------------------------------------------------
'
'Deklaration
'=Konstante
'-fr die Kennlinie des Temperatursensors
   Dim K_ts1(6) As Single                        'Konstante Sensor 1: K0- K3, t
 '*  Dim K_ts2(6) As Single                      'Konstante Sensor 2: K0- K3, t

'=Variable
   Dim Adw As Word                               'Spannungswert: Eingang analog
   Dim K_hv01 As Single                          'Hilsvariable 01

   Dim T_kor1 As Integer                         'Korrektur Sensor 1 (EEprom)
 '*  Dim T_kor2 As Integer                       'Korrektur Sensor 2 (EEprom)

'-Flag (F_)/ Merker (M_)/ Zhler (Z_)
   Dim F_anz As Bit                              'Flag: Anzeige Temperatur/Text
   Dim F_int As Bit                              'Flag: Interrupt Komparator
   Dim F_menutaste As Bit                        'Flag: Men Bettigung
   Dim F_mes As Bit                              'Flag: Messung aktiv
   Dim F_seg As Byte                             'Flag: Anzeige Segment
   Dim F_tm As Byte                              'Flag: Temperatur-Messung
   Dim F_taste As Bit                            'Flag: Taste

   Dim Mb01 As Byte                              'Merker 01, Func DA, EEprom
   Dim Mb02 As Byte                              'Merker 02, Segment-Steuerung

   Dim M_az As Byte                              'Merker: Abfragezyklus
   Dim M_menuestatus As Byte                     'Merker: Men Status
   Dim M_hel As Byte                             'Anzeige: Helligkeitswert 0- 9

   Dim M_seg As Byte                             'Anzeige: Segmente aktuell
   Dim M_seg1 As Byte                            'Anzeige: Segmente Digit 1
   Dim M_seg2 As Byte                            'Anzeige: Segmente Digit 2
   Dim M_seg3 As Byte                            'Anzeige: Segmente Digit 3
   Dim M_seg4 As Byte                            'Anzeige: Segmente Digit 4
   Dim M_seg5 As Byte                            'Anzeige: Segmente Digit 5
   Dim M_seg6 As Byte                            'Anzeige: Segmente Digit 6
   Dim M_segv As Byte                            'Anzeige: Segment-Vergleich

   Dim M_mes As Byte                             'Merker: 1:V   2:T1   3:T2
   Dim M_err12 As Long                           'Merker: Fehlermeldung 12

   Dim W_timer1 As Single                        'Wert: Timer 1
   Dim W_mes As Byte                             'Anzahl der Temperatur-Sensoren

   Dim Z_hz01 As Byte                            'Zhler: Hilfszhler 01
   Dim Z_hz02 As Byte                            'Zhler: Hilfszhler 02

   Dim Z_hel As Byte                             'Zhler: Anzeige-Helligkeit
   Dim Z_dig As Byte                             'Zhler: Anzeige-Digit
                                                 ' Digit 0 : 100.
                                                 ' Digit 1 :  10.
                                                 ' Digit 2 :   1.
                                                 ' Digit 3 :    .1
                                                 ' Digit 4 : 
                                                 ' Digit 5 : C

   Dim Z_menuestatus As Byte                     'Zhler: Men Status

   Dim R_ein As Integer                          'Relais: Einschalttemperatur
   Dim R_aus As Integer                          'Relais: Ausschalttemperatur
   Dim R_temp As Integer                         'Relais: Temperatur Vergleich

   Dim W_anz As String * 6                       'Anzeige: Text
   Dim W_anzs As String * 4                      'Anzeige: Teil vom Text

   Dim W_rt1 As Long                             'Wert: Temperatur-Sensor 1
   Dim W_alt As Long                             'Wert: Temperatur-Sensor 1 alt
'*   Dim W_rt2 As Long                           'Wert: Temperatur-Sensor 2

   Dim Z_tul As Byte                             'Zhler: berlauf Timer 0
   Dim Z_adc As Byte                             'Zhler: Helligkeit

'=Feld
'-Zeichen und korrespodierender Wert zur Anzeige
   Dim Zei(27) As String * 1                     'Feld: Zeichen
   Dim Zco(27) As Integer                        'Feld: Zeichencode fr Anzeige

'-Werte zur Mittelwertermittlung (Element [4] fr den Mittelwert
   Dim W_vw(5) As Word                           'Feld: Vergleichswiderstand
   Dim W_t1(5) As Word                           'Feld: Temperaturmessung 1
'*   Dim W_t2(5) As Word                        'Feld: Temperaturmessung 2
   Dim W_mw(2) As Long                           'Feld: Mittelwerte
'*   Dim W_mw(3) As Long                         'Feld: ... bei 2 Sensoren

'=Funktion
'-Kodierung der Segmente
   Declare Function Da(byval Anzeige As String) As Byte
'
'-------------------------------------------------------------------------------
'
'Initialisierung
'=I/O-Ports
'==Port B
'-Datenrichtung (Ein [0]: Eingang, Aus [1]: Ausgang)
   Ddrb = &B0001_1111                            'PB5(6,7) Ein, PB0-4 Aus
'-Pullup-Widerstand (passiv [0], aktiv [1])
   Portb = &B0000_0000                           'PB0-5(7) passiv
'
'==Port C
'-Datenrichtung (Ein [0]: Eingang, Aus [1]: Ausgang)
   Ddrc = &B1111_1110                            'PC0 Ein, PC1-5(7) Aus
'-Pullup-Widerstand (passiv [0], aktiv [1])
   Portc = &B0000_0000                           'PC0-5(7) passiv
'
'==Port D
'-Datenrichtung (Ein [0]: Eingang, Aus [1]: Ausgang)
   Ddrd = &B1110_0000                            'PD0-4 Ein, PD5-7 Aus
'-Pullup-Widerstand (passiv [0], aktiv [1])
   Portd = &B0001_0100                           'PD3,4 aktiv
'
'=Timer
'-Periodenzeit: Quarzfrequnz/ Teiler = 4 MHz/ 1 => T = 0,25 s
'--Timer0 (T0), Interrupt 0 (INT0) erfolgt beim berlauf (256)
   Config Timer0 = Timer , Prescale = 1          'Konfiguration Timer0 (T0)
   Config Timer1 = Timer , Prescale = 1          'Konfiguration Timer1 (T1)

   Config Int0 = Rising                          'Komparator: steigende Flanke

   On Timer0 Int_timer0                          'Interrupt: berlauf T0
   On Int0 Int_int0                              'Interrupt: KOM-Signal (Pin 4)

   Enable Timer0                                 'Einschalten: Interrupt T0
   Enable Int0                                   'Einschalten: Interrupt INT0
   Enable Interrupts                             'Interrupts : global zulassen
'
'-------------------------------------------------------------------------------
'
'Analog/Digital Konverter
'-Prescaler (Frequenzteiler durch 2, 4, 8, 16, 32, 64, 128)
'-ADC bentigt eine Frequenz von 50-200 kHz
'-Modus <AUTO>: hchstmgliche Frequenz wird gewhlt
'-interne Referenzspannungsquelle (2,56 V) nutzen
'-ADC erst starten, wenn Programm in die Schleife kommt!
   Config Adc = Single , Prescaler = Auto , Reference = Internal
'
'-------------------------------------------------------------------------------'-------------------------------------------------------------------------------
'
'Initialisierung
'=Konstante
'-Allgemein
   Z_adc = 34                                    'Anzeige beim Start

   M_hel = 5                                     'Helligkeit nach Start
   M_mes = 1                                     'Start der 1. Messung

   W_anz = "1n1"
   W_mes = 2                                     'Wert: Anzahl T-Sensoren +1
                                                 ' (+1: wegen Vergleichsmessung)

   Readeeprom R_ein , &H8                        'liest beim 1. Start "-1" aus,
   If R_ein = -1 Then                            ' daher Korrektur
      R_ein = 0                                  'Variable "R_ein" dient hier
      For Z_hz01 = 0 To 8 Step 2                 ' nur als 2 Byte-Hilfsvariable
         Writeeeprom R_ein , Z_hz01
      Next Z_hz01
   End If

   Readeeprom R_ein , &H0                        'Relais "ein" aus EEprom
   Readeeprom R_aus , &H2                        'Relais "aus" aus EEprom

   Readeeprom T_kor1 , &H4                       'Korrektur S1: EEprom (-2.1)
'* Readeeprom T_kor2 , &H6                       'Korrektur S2: EEprom (-2.1)

'-Kennlinie fr Temperatursensor 1:
' f(x)  =  K_ts1(1)  +  K_ts1(2)*R  +  K_ts1(3)*R^2  +  K_ts1(4)*R^3
   K_ts1(1) = -168                               'lt. f(x) K_ts1(1) = -160.124,
   K_ts1(2) = 0.246                              ' aber schon Korrekturwert ein-
   K_ts1(3) = -3857 / 53997444                   ' gerechnet (-8C in der Anzei-
   K_ts1(4) = 1 / 94892694                       ' ge)

'-Kennlinie fr Temperatursensor 2:
' f(x)  =  K_ts2(1)  +  K_ts2(2)*R  +  K_ts2(3)*R^2  +  K_ts2(4)*R^3
'*   K_ts2(1) = -160.124
'*   K_ts2(2) = 0.293
'*   K_ts2(3) = -3857 / 53997444
'*   K_ts2(4) = 1 / 94892694

'=Feld
'-Zeichen und korrespondierender Wert zur Anzeige einlesen
   Restore Data_zei
   For Z_hz01 = 1 To 27
      Read Zei(z_hz01)
   Next

   Restore Data_zco
   For Z_hz01 = 1 To 27
      Read Zco(z_hz01)
   Next
'
'-------------------------------------------------------------------------------
'
'Programm
Do
   Gosub Messung                                 'Routine: Temperatur-Messung
                                                 ' (Aufruf mu hier erfolgen)
'Fehlerbehandlung
   If F_anz = 1 Then                             'Flag: Fehler
      F_anz = 0                                  'Flag: Fehler lschen
      M_az = 0                                   'Schnellabfrage starten
   End If

   If M_az < 20 Then                             'Zeit fr Abfrage
      W_alt = W_rt1
      Incr M_az
      Waitms 10                                  'bei Programmstart: 10 ms
   Else
      Waitms 70                                  'spter: 70 ms  (40- 100 ms)
   End If                                        ' auch Zeit fr Tastendruck

'Anzeige Men
   If M_menuestatus > 0 Then
      Incr Z_menuestatus                         'Zhler: Automatik fr Men
      If Z_menuestatus = 10 Then                 'Men ausblenden
         Z_menuestatus = 0                       ' (10: Zeitfaktor)
         M_menuestatus = 0
         W_anz = " "
         Goto Mp01                               'Normierung: Anzeige
      End If

      Select Case R_ein                          'Grenze fr Relaiswert: Ein
         Case Is < -20                           ' (individuell laut Sensor)
            R_ein = -20
         Case Is > 100
            R_ein = 100
      End Select

      Select Case R_aus                          'Grenze fr Relaiswert: Aus
         Case Is < -20                           ' (individuell laut Sensor)
            R_aus = -20
         Case Is > 100
            R_aus = 100
      End Select

      Select Case T_kor1                         'Grenze fr den Korrekturwert
         Case Is < -99                           ' Temperatursensor 1
            T_kor1 = -99                         ' (+99 ... -99)
         Case Is > 99
            T_kor1 = 99
      End Select

      Select Case M_menuestatus                  'Auswahl des Anzeigewertes
         Case 1 To 2
            W_anz = Str(r_ein)                   'Relais: Ein
         Case 3 To 4
            W_anz = Str(r_aus)                   'Relais: Aus
         Case 5 To 6
            W_anz = Str(t_kor1)                  'Korrektur: Temperatursensor 1
      End Select

Mp03:
       If Len(w_anz) < 3 Then
         W_anz = " " + W_anz
         Goto Mp03
       End If

      If Pind.4 = 0 Then Z_menuestatus = 0       'Zeitverzgerung rcksetzen

      Select Case M_menuestatus
'Relais-Einschalttemperatur erhhen
         Case 1
            W_anz = "rEx" + W_anz                'Relais Ein (+)
            If Pind.4 = 0 Then
               Incr R_ein                        'Korrekturwert: +1C
               Writeeeprom R_ein , &H00
            End If
'Relais-Einschalttemperatur verringern
         Case 2
            W_anz = "rEy" + W_anz                'Relais Ein (+)
            If Pind.4 = 0 Then
               Decr R_ein                        'Korrekturwert: -1C
               Writeeeprom R_ein , &H00
            End If
'Relais-Ausschalttemperatur erhhen
         Case 3
            W_anz = "rAx" + W_anz                'Relais Ein (+)
            If Pind.4 = 0 Then
               Incr R_aus                        'Korrekturwert: +1C
               Writeeeprom R_aus , &H02
            End If
'Relais-Ausschalttemperatur verringern
         Case 4
            W_anz = "rAy" + W_anz                'Relais Ein (+)
            If Pind.4 = 0 Then
               Decr R_aus                        'Korrekturwert: -1C
               Writeeeprom R_aus , &H02
            End If
'Temperatur-Sensor 1: Korrektur positiv
         Case 5
            W_anz = "S1x" + W_anz                'Korrektur Sensor 1 (+)
            If Pind.4 = 0 Then
               Incr T_kor1                       'Korrekturwert: +1
               Incr W_alt
               Writeeeprom T_kor1 , &H04
            End If
'Temperatur-Sensor 1: Korrektur negativ
         Case 6
            W_anz = "S1y" + W_anz                'Korrektur Sensor 1 (-)
            If Pind.4 = 0 Then
               Decr T_kor1                       'Korrekturwert: -1
               Decr W_alt
               Writeeeprom T_kor1 , &H04
            End If
         Case 7
            If Pind.4 = 0 Then
               W_anz = "888888"                  'Test der Segmente
            Else
               W_anz = "PA    "                  'Test der Segmente
            End If
         Case 8
            W_anz = "End   "                     'Men verlassen
            M_menuestatus = 0
       End Select

       Goto Mp02

   End If

'Anzeige des Wertes in der Segmentanzeige
' erst, wenn mindestens 5 Messungen durchgefhrt wurden und keine nderung der
' Segment-Ansteuerung erfolgt
   If W_t1(5) > 0 And Z_tul = 2 Then
      F_anz = 0                                  'Anzeige: Temperatur

      If W_alt < W_rt1 Then Incr W_alt
      If W_alt > W_rt1 Then Decr W_alt

      Waitms 100                                 'Reduzierung der Anzeigedynamik
      W_anz = Str(w_alt)                         ' (Feinjustage)

      If W_alt < 0 And Len(w_anz) = 2 Then       '-1: => -0.1C
         W_anz = "-0" + Right(w_anz , 1)
      End If

      If W_alt > 0 And Len(w_anz) = 1 Then       '1: => 0.1C
         W_anz = "0" + Right(w_anz , 1)
      End If

      If W_alt = 0 Then                          '0: => 0.0C
         W_anz = "00"
      End If

      If W_alt < -250 Or W_alt > 1550 Then       'Sensor-Kurzschlu
         W_anz = "Err 11"
         F_anz = 1                               'Anzeige: Fehler 11
      End If

      If M_err12 > 6000 Then                     'Sensor-Unterbrechung
         W_anz = "Err 12"
         F_anz = 1                               'Anzeige: Fehler 12
      End If

'Temperaturanzeige
      If Len(w_anz) < 5 Then                     'Normierung: C
         W_anz = W_anz + "C"
      End If

Mp01:
      If Len(w_anz) < 6 Then                     'Normierung: Lnge 6 Zeichen
         W_anz = " " + W_anz
         Goto Mp01
      End If
   End If

Mp02:
   W_anzs = Mid(w_anz , 1 , 1)
      M_seg1 = Da(w_anzs)                        'Anzeige: Digit 1

   W_anzs = Mid(w_anz , 2 , 1)
      M_seg2 = Da(w_anzs)                        'Anzeige: Digit 2

   If F_anz = 0 And W_anz <> "1n1" And M_menuestatus = 0 Then
      W_anzs = Mid(w_anz , 3 , 1) + " "          'ggf. Punkt eintragen
   Else                                          ' Stringlnge 2 (+ " ")
      W_anzs = Mid(w_anz , 3 , 1)
   End If
         M_seg3 = Da(w_anzs)                     'Anzeige: Digit 3

   W_anzs = Mid(w_anz , 4 , 1)
      M_seg4 = Da(w_anzs)                        'Anzeige: Digit 4

   W_anzs = Mid(w_anz , 5 , 1)
      M_seg5 = Da(w_anzs)                        'Anzeige: Digit 5

   W_anzs = Mid(w_anz , 6 , 1)
      M_seg6 = Da(w_anzs)                        'Anzeige: Digit 6

'Schalten des Relais
   R_temp = W_rt1 / 10                           '1/10 abspalten

   If R_ein = R_aus Then Goto M_r01              'Relais: kein Schalten bei
                                                 ' gleichen Temperaturen
   If R_ein > R_aus Then
      If R_temp >= R_ein Then Portb.0 = 1        'Relais: Ein
      If R_temp <= R_aus Then Portb.0 = 0        'Relais: Aus
   Else
      If R_temp <= R_ein Then Portb.0 = 1        'Relais: Ein
      If R_temp >= R_aus Then Portb.0 = 0        'Relais: Aus
   End If
M_r01:

Loop
End                                              'Programmende

'-------------------------------------------------------------------------------
'=== I N T E R R U P T S  ======================================================
'-------------------------------------------------------------------------------
'=INT-Routine:
' berlauf Timer 0 zur Steuerung der Anzeige und deren Helligkeit
' - als Zhl-Eingang wird die interne Quarzfrequenz verwendet
' - nach Helligkeitsdurchlauf (Z_hel: 0-9) erfolgt die Digit-Umschaltung (Z_dig)
Int_timer0:
   Incr Z_tul                                    'Einstellung der Zeitbasis

   If Z_tul = 1 Then
      Gosub Helligkeit_taste2                    'Routine: Anzeige und Taste 2
   End If

   If Z_tul < 4 Then                             'f = 4 MHz, T = 0,25 s
      Goto M_ret1                                'berlauf T0 bei 64 s
   Else                                          '=> Routine zur Anzeige alle
      Z_tul = 0                                  '   256 s
      If Pind.0 = 0 Then                         'Abfrage: Entladung ber TS 1
         Incr M_err12                            'Merker: Fehlermeldung 12
      End If
   End If

   Incr Z_hel                                    'Einstellung: Helligkeit
   If Z_hel > 9 Then
      Z_hel = 0
'-alle Digits deaktivieren
      Portb.4 = 0                                'Dekoder sperren
      Portb.1 = 0 : Portb.2 = 0 : Portb.3 = 0    'A-B-C fr den Dekoder
      Incr Z_dig
      If Z_dig = 7 Then Z_dig = 1                'Zhlung: Digit
   End If

   If Z_hel = M_hel Then
'-Einschalten der Digits (Transistor-Anodentreiber)
' (Klammerwerte, z. B. LLH, fr den 1 aus 8 Dekoder)
      Select Case Z_dig
         Case 1
            M_seg = M_seg1                       'Segmente fr Digit 1
            Gosub Segment
              Portb.1 = 1                        'Digit aktiviert: 100. (LLH)
         Case 2
            M_seg = M_seg2                       'Segmente fr Digit 2
            Gosub Segment
               Portb.2 = 1                       'Digit aktiviert: 10.  (LHL)
         Case 3
            M_seg = M_seg3                       'Segmente fr Digit 3
            Gosub Segment
               Portb.1 = 1                       'Digit aktiviert: 1.   (LHH)
               Portb.2 = 1
         Case 4
            M_seg = M_seg4                       'Segmente fr Digit 4
            Gosub Segment
               Portb.3 = 1                       'Digit aktiviert: .1   (HLL)
         Case 5
            M_seg = M_seg5                       'Segmente fr Digit 5
            Gosub Segment
               Portb.1 = 1                       'Digit aktiviert: ""  (HLH)
               Portb.3 = 1
         Case 6
            M_seg = M_seg6                       'Segmente fr Digit 6
            Gosub Segment
               Portb.2 = 1                       'Digit aktiviert: "C"  (HHL)
               Portb.3 = 1
      End Select
      Waitus 10
      Portb.4 = 1                                'Dekoder freigeben (Enable)
   End If

M_ret1:
'whrend der Anzeige wurde der Komparator geschaltet (H->L)
   If Pind.2 = 0 And F_mes = 1 Then
      F_mes = 0
      Gifr.int0 = 1                              'ggf. Interrupt-Anforderung vom
   End If                                        ' Komparator abweisen

Return

Int_int0:
'Komparator schaltet, da Kondensator entladen
      W_timer1 = Timer1                          'Wert  : Timer 1 sichern
      F_int = 1                                  'Merker: Messung beendet
      M_err12 = 0                                'Merker: Fehlermeldung 12
Return

'-------------------------------------------------------------------------------
'=== F U N K T I O N E N =======================================================
'-------------------------------------------------------------------------------
'
'=Codierung der Segmente
'-Diese Funktion ermittelt aus der Digit- und Zeichenvorgabe den Segmentcode
Function Da(byval Anzeige As String)as Byte
'Funktion ber Auslesen von Feldern realisieren
' (bei einer Anzeige mit Punkt ist die Stringlnge 2)
   Mb01 = 0                                      'Merker: =0
   If Len(anzeige) = 2 Then Mb01 = 128           'Zeichen mit Punkt: +128
   Anzeige = Left(anzeige , 1)                   'fhrendes Zeichen ermitteln

   For Z_hz01 = 1 To 27                          'Feld mit Zeichen durchlaufen
      If Anzeige = Zei(z_hz01) Then              'Zeichen suchen
         Da = Zco(z_hz01)                        'Code ermitteln und ggf. Wert
         If Asc(anzeige) < 58 Then               ' (nur bei Ziffern) fr Punkt
            Da = Da + Mb01                       ' addieren
         End If
      End If
   Next Z_hz01

End Function

'-------------------------------------------------------------------------------
'=== U N T E R P R O G R A M M E ===============================================
'-------------------------------------------------------------------------------
'
Segment:
'=Routine: Segmente aktualisieren
'-Segmente der 7-Segmentanzeige sind im Merker M_seg fr das aktuelle Digit
' bitcodiert abgelegt: 0-a  1-b  2-c  3-d  4-e  5-f  6-g  7-p
'--alle Segmente ausschalten
   Portc.1 = 0 : Portc.2 = 0 : Portc.3 = 0       'Port C
   Portc.4 = 0 : Portc.5 = 0                     'Port C

   Portd.5 = 0 : Portd.6 = 0 : Portd.7 = 0       'Port D

'-Segmente je nach Bedarf in den einzelnen Digits zuschalten
   Mb02 = 128                                    'Initialisierung: 8. Segment
Ma_01:
   Rotate Mb02 , Left , 1
   F_seg = Mb02 And M_seg

   Select Case F_seg
      Case 1                                     'Segment 1 (a)
         Portc.1 = 1
      Case 2                                     'Segment 2 (b)
         Portc.2 = 1
      Case 4                                     'Segment 3 (c)
         Portc.3 = 1
      Case 8                                     'Segment 4 (d)
         Portc.4 = 1
      Case 16                                    'Segment 5 (e)
         Portc.5 = 1
      Case 32                                    'Segment 6 (f)
         Portd.5 = 1
      Case 64                                    'Segment 7 (g)
         Portd.6 = 1
      Case 128                                   'Segment 8 (dp)
         Portd.7 = 1
   End Select

   If Mb02 < 128 Then Goto Ma_01                 'Schleifendurchlauf

Return

Helligkeit_taste2:
'=Routine: Helligkeit der Anzeige
'-steuert die Helligkeit der Anzeige in Abhngigkeit der Umgebungshelligkeit
' und fragt eine Bettigung der Taste 2 (Modus) ab
'-Aufruf erfolgt, wenn keine Steuerung der Anzeige erfolgt
   Incr Z_adc
   If Z_adc = 35 Then                            '35: guter Wert
      Z_adc = 0                                  ' (10: schnell - 50: langsam)
      Start Adc
         Adw = Getadc(0)                         'AD-Wandler: Kanal 0 abfragen
         If Adw > 10 Then                        'Taste 2 nicht bettigt
            Shift Adw , Right , 2                'Normierung auf 8 Bit (255)
            If Adw > 225 Then Adw = 225
            If Adw < 25 Then Adw = 25
            Adw = Adw / 25                       'Normierung auf 1-9   (25/225)
            M_hel = 10 - Adw                     'Helligkeit einstellen
            F_menutaste = 0
         Else
'Taster-Abfrage
            Z_menuestatus = 0                    'Zhler fr Anzeigelnge
            If F_menutaste = 0 Then
               F_menutaste = 1
               Incr M_menuestatus
'maximale Anzahl der Meneintrge: 9
               If M_menuestatus = 9 Then M_menuestatus = 0
            End If
         End If
      Stop Adc
   End If
Return

Messung:
'=Routine: Temperaturmessung V (Entladung ber den Vergleichswiderstand)
'-Temperaturmessung: Vergleichswiderstand
   If F_mes = 0 Then
      Disable Interrupts
         F_mes = 1                               'Messung beginnt
         Config Pinb.5 = Output : Portb.5 = 1    'Kondensator laden
      Enable Interrupts
      Waitms 30                                  'Zeitspanne zum Laden des
                                                 ' Kondensators (30 ms)
      Disable Interrupts                         'keine Strung von der Anzeige
         Config Pinb.5 = Input                   'Ladung beenden (Input)

         Select Case M_mes
            Case 1
               Config Pind.3 = Output : Portd.3 = 0       'Mewiderstand V: ein
            Case 2
               Config Pind.0 = Output : Portd.0 = 0       'Mewiderstand T1: ein
 '*         Case 3
 '*            Config Pind.1 = Output : Portd.1 = 0       'Mewiderstand T2: ein
         End Select
         Timer1 = 0                              'Timer neu starten
      Enable Interrupts

   End If

   Gosub Messung_anzeige

Return

Messung_anzeige:
'Mewertanzeige nur, wenn kein Interrupt whrend der Messung
If F_int = 1 Then
   F_int = 0                                     'Merker: Interrupt rcksetzen
   F_mes = 0

   Config Pind.0 = Input                         'Mewiderstand T1: aus (Input)
'* Config Pind.1 = Input                         'Mewiderstand T2: aus (Input)
   Config Pind.3 = Input                         'Mewiderstand V : aus (Input)

   W_timer1 = W_timer1 / 5
   W_timer1 = Fix(w_timer1)

'alte Messwerte in den entsprechenden Feldvariablen speichern
   For Z_hz02 = 5 To 2 Step -1
      Select Case M_mes
          Case 1
             W_vw(z_hz02) = W_vw(z_hz02 - 1)     'aktuellen Widerstandswert ein-
             W_vw(1) = W_timer1                  ' tragen
          Case 2
             W_t1(z_hz02) = W_t1(z_hz02 - 1)     'aktuellen Widerstandswert ein-
             W_t1(1) = W_timer1                  ' tragen
'*        Case 3
'*           W_t2(z_hz02) = W_t2(z_hz02 - 1)     'aktuellen Widerstandswert ein-
'*           W_t2(1) = W_timer1                  ' tragen
      End Select
   Next Z_hz02

'Berechnung der Mittelwerte
   If W_vw(5) > 500 And W_t1(5) > 500 Then       'Mewerte VW und TS1 ok
      W_mw(1) = 0 : W_mw(2) = 0                  'Mittelwerte = 0
'     W_mw(3) = 0                                'Mittelwerte = 0

      For Z_hz02 = 1 To 5                        'Werte summieren
         W_mw(1) = W_mw(1) + W_vw(z_hz02)        ' - fr Vergleichswiderstand
         W_mw(2) = W_mw(2) + W_t1(z_hz02)        ' - fr Temperatursensor 1
'*       W_mw(3) = W_mw(3) + W_t2(z_hz02)
      Next Z_hz02

'Widerstands-Berechnung Temperatur-Sensor 1
      W_rt1 = 1000 * W_mw(2)
      W_rt1 = W_rt1 / W_mw(1)
      W_rt1 = W_rt1 - 1000

'Widerstands-Berechnung Temperatur-Sensor 2
'*    W_rt2 = 1000 * W_mw(3)
'*    W_rt2 = W_rt2 / W_mw(1)
'*    W_rt2 = W_rt2 - 1000

'Berechnung der dazugehrigen Temperatur (Temperatur-Sensor 1)
      K_hv01 = K_ts1(2) * W_rt1                  'Wert: K1*R
      K_ts1(5) = K_ts1(1) + K_hv01               'Wert: +K0
      K_hv01 = W_rt1 ^ 2                         'Wert: R^2
      K_hv01 = K_ts1(3) * K_hv01                 'Wert: K2*R^2
      K_ts1(5) = K_ts1(5) + K_hv01               'Wert: K0+K1*R+K2*R^2
      K_hv01 = W_rt1 ^ 3                         'Wert: R^3
      K_hv01 = K_ts1(4) * K_hv01                 'Wert: K3*R^3
      K_ts1(5) = K_ts1(5) + K_hv01               'Wert: K0+K1*R+K2*R^2+K3*R^3

      K_ts1(5) = K_ts1(5) * 10                   'Stelle 1/10 vor Komma
      K_ts1(5) = K_ts1(5) + T_kor1               'Korrekturwert aus EEprom

      W_rt1 = Int(k_ts1(5))                      'Runden auf volle Werte

'Berechnung der dazugehrigen Temperatur (Temperatur-Sensor 2)
'*    K_hv01 = K_ts2(2) * W_rt2                  'Wert: K1*R
'*    K_ts1(5) = K_ts2(1) + K_hv01               'Wert: +K0
'*    K_hv01 = W_rt2 ^ 2                         'Wert: R^2
'*    K_hv01 = K_hv01 * K_ts2(3)                 'Wert: K2*R^2
'*    K_ts2(5) = K_ts2(5) + K_hv01               'Wert: K0+K1*R+K2*R^2
'*    K_hv01 = W_rt2 ^ 3                         'Wert: R^3
'*    K_hv01 = K_hv01 * K_ts2(4)                 'Wert: K3*R^3
'*    K_ts2(5) = K_ts2(5) + K_hv01               'Wert: K0+K1*R+K2*R^2+K3*R^3

'*    K_ts2(5) = K_ts2(5) * 10                   'Stelle: 1/10
'*    K_ts2(5) = K_ts2(5) + T_kor2               'Korrekturwert aus EEprom

'*    W_rt2 = Int(k_ts2(5))                      'Runden auf volle Werte

   End If

   Incr M_mes                                    'Merker: Messung
   If M_mes > W_mes Then M_mes = 1               'durchluft alle Messungen
End If

Return

End

'Datenbereich: Zeichen
'x, y: Code fr Sonderzeichen (nicht die Buchstaben selbst)
Data_zei:
   Data "1" , "2" , "3" , "4" , "5" , "6" , "7" , "8" , "9" , "0"
   Data "A" , "b" , "C" , "d" , "E" , "F" , "H" , "-" , " " , ""
   Data "r" , "o" , "n" , "S" , "x" , "y" , "P"

'Datenbereich: Zeichencode
Data_zco:
   Data 006% , 091% , 079% , 102% , 109% , 125% , 007% , 127% , 111% , 063%
   Data 119% , 124% , 057% , 094% , 121% , 113% , 118% , 064% , 000% , 099%
   Data 080% , 092% , 084% , 109% , 001% , 008% , 115%

'Programmende